
import ConfigParser
import StringIO
import os, sys, tempfile, shutil

config_file = "goodnewsrc"

default_config = """


[System]

HomeDir = %(home)s
Version = %(version)s

[General]

; Browser command to run to open urls
Browser = lynx %%s

; How long to wait for a response when connecting a server
SocketTimeout = 20

; Config
ConfigDir = %%(HomeDir)s/.goodnews-%%(Version)s/
ConfigFile = %%(ConfigDir)s/goodnewsrc

; Directory to store goodnews' cache on disk
CacheDir = %%(ConfigDir)s/cache

; Only use 'latin-1', 'iso-8859-1', or 'utf-8' 
DefaultEncoding = utf-8

[Colors]

[Keybindings]

[Feeds]


""" % {'home': os.environ.get('HOME'),
       'version': '0.9.5pre'}


class Config:

    def __init__(self, file=''):

        self.file = file
        _defaults = StringIO.StringIO(default_config)

        # load default values
        self.config = ConfigParser.SafeConfigParser()
        self.config.readfp(_defaults)

        if not file:
            file = self._search_for_config()
        
        if not os.path.exists(file):
            print >> sys.stderr, "Warning config file '%s' doesn't exists" % file

        # load user settings
        self.config.read(file)


    def _search_for_config(self):
        print self.get('DEFAULT', 'ConfigFile')
        return ''

    def get(self, section, option):
        if self.config.has_option(section, option):
            return self.config.get(section, option)
        else:
            return self.config.defaults().get(option)
        
    def set(self, section, option,value):
        self.config.set(section, option, value)

    def write(self):
        tempfd, tempfname = tempfile.mkstemp(prefix='goodnews-')
        fp = os.fdopen(tempfd, 'w')
        self.config.remove_section('System')
        self.config.write(fp)
        fp.close()
        shutil.move(tempfname, self.file)


    def get_urls(self):
        try:
            urls = [url for k, url in self.config.items('Feeds') if url[:4] == 'http']
        except ConfigParser.NoSectionError:
            urls = []

        return urls
            
    def add_urls(self, urls):

        # delete all urls from config
        self.config.remove_section('Feeds')
        self.config.add_section('Feeds')
        
        if not urls:
            #self.write()
            return
        
        i = 0
        for url in urls:
            self.set('Feeds', 'feed'+str(i), url)
            i+= 1
            
        #self.write()
        

    def get_browser(self):
        return self.config.get('General', 'browser')
    

    def add_browser(self, browser):
        _old = self.get_browser()

        try:
            self.config.set('General', 'browser', browser)
            self.config.get('General', 'broser') # check
            #self.write()
        except:
            self.config.set('General', 'browser', _old)
        
        
