#!/usr/bin/python2

import sys
import os, shutil
import curses
import urllib, urlparse
import timeoutsocket
import locale
import time
import string, StringIO
import re
import sha
import textwrap
import cPickle
import threading
import math
import md5

#import ctypescurses._ctypescurses as curses

# local modules
from version import version as VERSION
import config
import textfield

# 3rd party modules
import feedparser
import html2text



# use_default_colors was added in python 2.4
# if we don't have it, don't bother with colors
if not hasattr(curses, "use_default_colors"):
    try:
        import curses_extra
        curses.use_default_colors = curses_extra.use_default_colors
        BGCOLOR = -1
        USE_COLORS = 1
    except:
        def use_default_colors():
            pass
        BGCOLOR = curses.COLOR_WHITE
        USE_COLORS = 0
        curses.use_default_colors = use_default_colors
else:
    BGCOLOR = -1
    USE_COLORS = 1


reload(sys)
# FIXME: fetch this value from config
sys.setdefaultencoding('utf-8')

# Set the User-Agent string
USER_AGENT = "Goodnews/%s (%s)" % (VERSION, sys.platform)

class GoodnewsURLopener(urllib.FancyURLopener):
    version = USER_AGENT
urllib._urlopener = GoodnewsURLopener()

update_all_running = 0
CMD_SLOTS_COLUMNS =6 
CMD_SLOTS = (CMD_SLOTS_COLUMNS * 2) - 1


cur_cmd_grp = []
keybinding = {}
first_ptr = []
first_scr_ptr = 0



class Pager:

    def __init__(self, rows, cols, txt=""):
        self.rows, self.cols = rows, cols
        self.pages = 0
        self.page  = 0
        self.offset = 0
        self.lines = []
        if txt:
            self._data = self.data(txt)

    def resize(self, rows, cols):
        self.rows, self.cols = rows, cols
        self.data(self._data)
        #self.home()

    def data(self, txt=""):
        if txt:
            self._data = txt
            lines = txt.split('\n')
            self.lines = [line[:self.cols] for line in lines]
            self.pages = int(math.ceil(len(self.lines) / (self.rows)))
            self.home()
        else:
            return "\n".join(self.lines[(self.rows * self.page) + self._rel_offset(): (self.rows * (self.page+1)) + self._rel_offset()])
            

    def up(self, npages=1):
        if self.page: 
            self.page -= 1
            self.offset = self._cur_offset(self.page)
            return 1
        else:
            self.offset = 0
            return 0

    def down(self, npages=1):
        if self.page < self.pages: 
            self.page += 1
            self.offset = self._cur_offset(self.page)
            return 1
        else:
            return 0

    def home(self):
        self.page = self.offset = 0

    def end(self):
        self.page = self.pages
        self.offset = 0

    def scroll(self, nlines=1):
        if self.offset < (len(self.lines) - self.rows):
            self.offset += 1
            self.page = self._cur_page(self.offset)

    def _cur_page(self, offset):
        self.page = int(math.ceil(offset / (self.rows)))
        return self.page

    def _rel_offset(self):
        return self.offset - (self.page * self.rows)

    def _cur_offset(self, page):
        self.offset = (page * self.rows)
        return self.offset


class FeedMenu:

    def __init__(self):
        self.first_scr_ptr = 0
        self.items = {}
        self.sorted = []
        

class Feed:
    def __init__(self):
        self.id = ""
        self.feedurl = ""
        #self.feed = ""
        self.feed_data = ""
        self.title = ""
        self.link = ""
        self.description = ""
        self.lastmodified = ""
        self.lasthttpstatus = 0
        self.highlighted = None
        
        self.items = {}
        self.sorted = []
        self.expired = {}

        self.first_scr_ptr = 0
        
        self.problem = 0
        self.override = ""
        self.original = ""

        self.categories = ()

        self.bozo = 0
        self.update_msg = ""

        

class NewsItem:
    def __init__(self):
        self.readstatus = 0
        self.title = ""
        self.link = ""
        self.description = ""
        self.html = ""
        self.id = ""
        self.timestamp = 0
        self.pager = None



def ex_entry_field(stdscr, default=""):

    LINES, COLS = stdscr.getmaxyx()
    
    win = curses.newwin(3, COLS -4)

    win.mvwin((LINES//2) - 2, 2)
    win.box()
    win.refresh()
    
    text_win = curses.newwin(1,COLS - 6)
    text_win.mvwin((LINES//2) - 2 + 1, 3)
    
    textpad  = textfield.Textfield(text_win, default)
    t = textpad.run()

    stdscr.clear()
    
    return t

    
def InitCurses():
    
    stdscr = curses.initscr()

    stdscr.keypad(1)
    curses.cbreak()
    curses.noecho()

    stdscr.clear()

    
    stdscr.refresh()
    LINES, COLS = stdscr.getmaxyx()

    if USE_COLORS:
        
        curses.start_color();

        #default color for fg/bg set to -1
        curses.use_default_colors()

        # FIXME: find a pleasing color combo
        curses.init_pair (10, 1, BGCOLOR); #/* red */
        curses.init_pair (11, 2, BGCOLOR); #/* green */
        curses.init_pair (12, 3, BGCOLOR); #/* orange */
        curses.init_pair (13, 4, BGCOLOR); #/* blue */
        curses.init_pair (14, 5, BGCOLOR); #/* magenta */
        curses.init_pair (15, 6, BGCOLOR); #/* cyan */
        curses.init_pair (16, 7, BGCOLOR); #* gray */
        curses.init_pair (17, curses.COLOR_YELLOW, curses.COLOR_BLUE)
        curses.init_pair (18, curses.COLOR_WHITE, curses.COLOR_BLUE)

    return stdscr
    
def draw_status(stdscr, txt, delay=0):
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS -1
    stdscr.attron (curses.A_BOLD)

    # clear
    stdscr.addstr(LINES-3, 0, ' '*COLS)

    if USE_COLORS:
        stdscr.addstr (LINES-3, 1, txt[:COLS-2], curses.color_pair(10));
    else:
        stdscr.addstr (LINES-3, 1, txt[COLS-2])

    stdscr.attroff (curses.A_BOLD);
    stdscr.refresh()
    
    if delay:
        time.sleep(delay)

    

def draw_header (stdscr, filterstring="", use_colors=USE_COLORS):
    LINES, COLS = stdscr.getmaxyx()

    headerline = ""
    
    attrs = curses.A_BOLD
    
    if use_colors:
        attrs = curses.color_pair(17)|curses.A_BOLD

    stdscr.addstr(0, 0, ' '*COLS, attrs);
    stdscr.addstr(0, 1, "* %s" % USER_AGENT, attrs)

    if filterstring:
        stdscr.addstr(0, COLS-len(filterstring)-1, filterstring, attrs);

    if cfg.get_bozo():
        stdscr.addstr(0, len(USER_AGENT) + 10, "*bozo*", attrs)
        
    stdscr.refresh()


def draw_footer(stdscr, cur_grp, bindings):
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS - 1
    slots = CMD_SLOTS_COLUMNS
            
    grp = cur_grp[:]
    
    slotspace = columns // slots

    # clear the space
    stdscr.addstr(LINES-1, 0, ' '* columns)
    stdscr.addstr(LINES-2, 0, ' '* columns)

    # draw new
    for y in (LINES - 2, LINES - 1):
        for x in range(slots):

            if not grp:
                break
            
            i = grp.pop(0)
                
            if bindings.has_key(i):
                outstr = bindings[i]
                outstr = outstr.split('_')[-1]
            elif i == '^O':
                outstr = "morecmds"
            else:
                outstr = "no cmd"
            
            stdscr.attron (curses.A_STANDOUT)
            stdscr.addstr(y, x * slotspace, repr(i))
            stdscr.attroff (curses.A_STANDOUT)
            
            if len(outstr) < slotspace - 5:
                padding = (slotspace - 5) - len(outstr)
                outstr += " "* padding
            else:
                outstr = outstr[:slotspace -5]
        
            stdscr.addstr(y, (x * slotspace) + len(repr(i)) + 1, outstr)

        

def dump_traceback(stdscr, s):
    configdir = cfg.get_configdir()
    try:
        open(configdir + '/last_traceback_dump.txt', 'w+').write(s)
    except:
        pass
    
    stdscr.move(2,0)
    stdscr.addstr(s)
    draw_status(stdscr, "****** CRASH CRASH CRASH ******\n****** Press Any Key To Continue ******", 0)
    stdscr.getch()



## KEYBINDINGS ##
def keylocked(fn):
    def new(*args, **kws):
        global has_keylock
        keylock.acquire()
        has_keylock = True

        if not update_all_running:        
            res = fn(*args, **kws)
        else:
            res = None

        has_keylock = False
        keylock.release()
        return res
    return new


def do_unlocked(fn):
    def new(*args, **kws):
        global has_keylock
        keylock_before = has_keylock

        if keylock_before:
            has_keylock = False
            keylock.release()
        
        res = fn(*args, **kws)

        if keylock_before:
            keylock.acquire()
            has_keylock = True

        return res
    return new


@keylocked
def keybind_morecmds(stdscr, **args):
    global cur_cmd_grp

    if args.has_key('bindings'):
        bindings = args['bindings']
    else:
        return

    slots = CMD_SLOTS
    
    kys = bindings.keys()
    kys.sort()
    k = []

    for j in kys:
        if not type(j) == type(0):
            k.append(j)

    i = k.index(cur_cmd_grp[-2])

    if not cur_cmd_grp[-1] == '^O' or cur_cmd_grp[-2] == k[-1]:
        i = -1

    if len(k) > CMD_SLOTS:
        cur_cmd_grp = k[i + 1:i + 1 + slots]
        cur_cmd_grp.append('^O')
    else:
        cur_cmd_grp = k[:slots + 1]        

    draw_footer(stdscr, cur_cmd_grp, bindings)


@keylocked
def keybind_bozo(stdscr, **args):
    cfg.set_bozo(not cfg.get_bozo())

@keylocked    
def keybind_quit(scr, **args):
    return 1


@keylocked
def keybind_addfeed(stdscr, **args):
    global highlighted
    
    ptr = add_feed(stdscr, first_ptr)
    if ptr:
        highlighted = first_ptr[-1]
    

@keylocked        
def keybind_delfeed(stdscr, **args):

    deletion = highlighted

    if deletion == first_ptr[0]:
        keybind_next(stdscr)
    else:
        keybind_prev(stdscr)
    
    first_ptr.remove(deletion)
    stdscr.clear()

@keylocked
def keybind_allread(stdscr, **args):
    for i in highlighted.items:
        highlighted.items[i].readstatus = 1
    pass


@keylocked
def keybind_browser(stdscr, **args):
    draw_status(stdscr, 'Enter a browser command. Example: lynx "%s" (%s is the URL)', 0)
    s = ex_entry_field(stdscr, cfg.get_browser())
    
    if s:
        cfg.set_browser(s)

    draw_status(stdscr, '', 0)        

@keylocked
def keybind_editfeedurl(stdscr, **args):
    draw_status(stdscr, 'Edit the feed url', 0)    
    _url = highlighted.feedurl
    
    url = ex_entry_field(stdscr, highlighted.feedurl)
    if url and url != _url:
        highlighted.feedurl = url
        update_feed(stdscr, highlighted)
    draw_status(stdscr, '', 0)

@keylocked    
def keybind_feedname(stdscr, **args):
    
    draw_status(stdscr, 'Enter a feed name', 0)
    s = ex_entry_field(stdscr, highlighted.title)
    
    if s:
        highlighted.title = s
    else:
        highlighted.title = highlighted._title

    draw_status(stdscr, '', 0)

@keylocked        
def keybind_moveup(stdscr, **args):

    i =  first_ptr.index(highlighted)
    cut = first_ptr.remove(highlighted)
    
    if i > 0:
        i -= 1

    first_ptr.insert(i, highlighted)

@keylocked
def keybind_movedown(stdscr, **args):
    i =  first_ptr.index(highlighted)
    cut = first_ptr.remove(highlighted)
    
    if i < len(first_ptr):
        i += 1

    first_ptr.insert(i, highlighted)

@keylocked
def keybind_feedinfo(stdscr, **args):
    pass

@keylocked
def keybind_reload(stdscr, **args):
    update_feed(stdscr, highlighted)

@keylocked
def keybind_reloadall(stdscr, **args):
    update_all_feeds(stdscr, first_ptr, draw_feeds, highlighted, args['bindings'])

@keylocked
def keybind_saveall(stdscr, **args):
    draw_status(stdscr, "Saving all states...", 0)
    save_all(stdscr)

@keylocked    
def keybind_urljump (stdscr, **args):
    LINES, COLS = stdscr.getmaxyx()

    if not syscall:
        return

    draw_status(stdscr, "Executing: %s ..."% syscall[:COLS-7], 0)
    ret = os.system("%s 2>/dev/null"% syscall)
    
    if ret:
        draw_status(stdscr, "Error '%i' from browser command..."% ret, 2)

@keylocked
def keybind_urljump2(stdscr, **args):
    pass

@keylocked
def keybind_sortfeeds (stdscr, **args):
    pass

"""
@keylocked
def keybind_pup(stdscr, **args):
    pass

@keylocked
def keybind_pdown(stdscr, **args):
    pass
"""

@keylocked
def keybind_categorize(stdscr, **args):
    pass

@keylocked
def keybind_filter(stdscr, **args):
    pass

@keylocked
def keybind_filtercurrent(stdscr, **args):
    pass

@keylocked
def keybind_nofilter(stdscr, **args):
    pass

@keylocked
def keybind_help(stdscr, **args):
    pass

@keylocked
def keybind_about(stdscr, **args):
    pass


@keylocked
def keybind_next(stdscr, **args):
    global highlighted, first_scr_ptr

    LINES,COLS = stdscr.getmaxyx()
    maxlines = LINES - 6

    if not first_ptr:
        return

    if first_ptr.index(highlighted) < len(first_ptr) -1:
        highlighted = first_ptr[first_ptr.index(highlighted) + 1]

    if first_ptr.index(highlighted) - first_scr_ptr > (maxlines - 4):
        first_scr_ptr += 1


@keylocked
def keybind_prev(stdscr, **args):
    global highlighted, first_scr_ptr
    
    if not first_ptr:
        return
    
    if first_ptr.index(highlighted) > 0:
        highlighted = first_ptr[first_ptr.index(highlighted) - 1]

    if (first_ptr.index(highlighted) - first_scr_ptr) < 0:
        first_scr_ptr -= 1
    

@keylocked
def keybind_feed_down(stdscr, **args):
    LINES,COLS = stdscr.getmaxyx()
    maxlines = LINES - 6
    index = cur_feed.sorted.index(cur_feed.highlighted.id)

    if index < len(cur_feed.items) -1 :
        index += 1
        cur_feed.highlighted = cur_feed.items[cur_feed.sorted[index]]

    if (index - cur_feed.first_scr_ptr) > (maxlines - 4):
        cur_feed.first_scr_ptr += 1

    if cur_feed.highlighted.pager:
        cur_feed.highlighted.pager.home()

@keylocked
def keybind_feed_up(stdscr, **args):
    if cur_feed.sorted.index(cur_feed.highlighted.id) > 0:
        cur_feed.highlighted = cur_feed.items[cur_feed.sorted[cur_feed.sorted.index(cur_feed.highlighted.id) - 1]]

    if (cur_feed.sorted.index(cur_feed.highlighted.id) - cur_feed.first_scr_ptr) < 0:
        cur_feed.first_scr_ptr -= 1
    
    if cur_feed.highlighted.pager:
        cur_feed.highlighted.pager.home()

@keylocked    
def keybind_mark_item_read(stdscr, **args):
    cur_feed.highlighted.readstatus = 1
    do_unlocked(keybind_feed_down)(stdscr)


@keylocked
def keybind_mark_item_unread(stdscr, **args):
    cur_feed.highlighted.readstatus = 0
    do_unlocked(keybind_feed_down)(stdscr)


@keylocked    
def keybind_select(stdscr, **args):
    global cur_cmd_grp, mainmenu

    mainmenu = False
    
    item_keybind = {}

    item_keybind['m'] = 'keybind_allread'
    item_keybind['q'] = 'keybind_quit'
    item_keybind['o'] = 'keybind_urljump'
    item_keybind[curses.KEY_UP] = 'keybind_feed_up'
    item_keybind[curses.KEY_DOWN] = 'keybind_feed_down'


    item_keybind['d'] = 'keybind_mark_item_read'
    item_keybind['u'] = 'keybind_mark_item_unread'
    
    item_keybind['n'] = 'keybind_feed_down'
    item_keybind['p'] = 'keybind_feed_up'

    item_keybind['N'] = 'keybind_next'
    item_keybind['P'] = 'keybind_prev'    
    
    item_keybind['\n'] = 'keybind_feed_select'
    item_keybind[' '] = 'keybind_feed_select'    

    item_keybind['B'] = 'keybind_browser'
    item_keybind['V'] = 'debug_shell'

    if not first_ptr:
        return

    if not highlighted.items:
        draw_status(stdscr, "Warning: No items to show!", 2)
        return
    
    LINES,COLS = stdscr.getmaxyx()
    maxlines = LINES - 6

    highlighted.highlighted = highlighted.items[highlighted.sorted[0]]
    cur = max = 0
    highlighted.first_scr_ptr = 0
    
    for i in highlighted.sorted:
        if cur > maxlines - 4:
            max += 1
        cur += 1            

        if not highlighted.items[i].readstatus:
            highlighted.highlighted = highlighted.items[i]
            highlighted.first_scr_ptr = max
            break

    cur_cmd_grp = setup_cmd_grp(item_keybind)
    stdscr.clear()
    
    while 1:
        draw_news(stdscr, highlighted)
        draw_footer(stdscr, cur_cmd_grp, item_keybind)        
        if do_main_cmdloop(stdscr, 0, item_keybind):
            cur_cmd_grp = setup_cmd_grp(args['bindings'])
            stdscr.clear()
            break
        
    mainmenu = True
        
def setup_cmd_grp(bindings):
    
    cmd_grp = []
    
    k = bindings.keys()
    k.sort()

    for j in k:
        if not type(j) == type(0):
            cmd_grp.append(j)
            
    if len(cmd_grp) > CMD_SLOTS:
        grp = cmd_grp[:CMD_SLOTS]
        grp.append('^O')
    else:
        grp = cmd_grp[:CMD_SLOTS + 1]
        
    return grp


@keylocked
def keybind_feed_enter_quit(stdscr, **args):

    if not cur_feed.highlighted:
        return 1
    
    # quit return if there are no more read items
    if not [i for i in cur_feed.items.values() if not i.readstatus]:
        curses.ungetch('q')
        return 1


    # find next unread

    #index = cur_feed.sorted.index(cur_feed.highlighted.id)
    """
    for i in cur_feed.sorted[index:]:
        cur_feed.first_scr_ptr += 1
        if not cur_feed.items[i].readstatus:
            cur_feed.highlighted = cur_feed.items[i]
            #LINES,COLS = stdscr.getmaxyx()
            #maxlines = LINES - 6
            #if (cur_feed.sorted.index(cur_feed.highlighted.id) - cur_feed.first_scr_ptr) > (maxlines - 4):
            #
            #    cur_feed.first_scr_ptr = maxlines - 4

            return 1
    """

    # if next unread

    while cur_feed.highlighted.id != cur_feed.sorted[-1]:
        do_unlocked(keybind_feed_down)(stdscr)
        if not cur_feed.highlighted.readstatus:
            return 1


    # send quit to parent and quit
    curses.ungetch('q')
    return 1

def keybind_item_pgdown(stdscr, **args):
    if not cur_feed.highlighted.pager.down():
        return keybind_feed_enter_quit(stdscr, **args)

@keylocked
def keybind_item_pgup(stdscr, **args):
    cur_feed.highlighted.pager.up()

@keylocked
def keybind_feed_select(stdscr, **args):
    global cur_cmd_grp, cur_keybind, mainmenu

    mainmenu = False
    
    item_keybind = {}
    
    item_keybind['q'] = 'keybind_quit'
    item_keybind['o'] = 'keybind_urljump'
    item_keybind['p'] = 'keybind_feed_up'
    item_keybind['n'] = 'keybind_feed_down'
    item_keybind['\n'] = 'keybind_feed_enter_quit'
    item_keybind[' '] = 'keybind_item_pgdown'
    item_keybind['b'] = 'keybind_item_pgup'
    item_keybind['B'] = 'keybind_browser'
    item_keybind[curses.KEY_UP] = 'keybind_feed_up'
    item_keybind[curses.KEY_DOWN] = 'keybind_feed_down'
    item_keybind[curses.KEY_NPAGE] = 'keybind_item_pgdown'
    item_keybind[curses.KEY_PPAGE] = 'keybind_item_pgup'
    item_keybind['V'] = 'debug_shell'
    cur_cmd_grp = setup_cmd_grp(item_keybind)

    # init the pager
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS - 10
    maxlines = LINES - 13

    stdscr.clear()    
    while 1:
        draw_item(stdscr, cur_feed)
        draw_footer(stdscr, cur_cmd_grp, item_keybind)
        if do_main_cmdloop(stdscr, 0, item_keybind):
            cur_cmd_grp = setup_cmd_grp(args['bindings'])
            stdscr.clear()
            break


def enter_main(stdscr, ptr, keybindings, encoding='latin-1'):
    global highlighted, first_ptr, saved_keybindings, syscall, cur_cmd_grp, mainmenu

    syscall = ""

    saved_keybindings = keybindings
    first_ptr = ptr

    k = keybindings.keys()
    k.sort()

    typeahead = 0;
    
    catfilter = "" #/* Category filter. Must be NULL when not used! */
    filteractivated = 0; #/* Set if filter was activated */

    forceredraw = 0

    first_src_ptr = 0
    if first_ptr:
        highlighted = first_ptr[0]
    else:
        highlighted = None
        
    stdscr.clear()
    
    cur_cmd_grp = setup_cmd_grp(keybindings)
    
    while 1:
        stdscr.move(0,0)
        draw_header(stdscr, catfilter)
        draw_feeds(stdscr, first_ptr, highlighted, keybindings)
        draw_footer(stdscr, cur_cmd_grp, keybindings)

        if do_main_cmdloop(stdscr, typeahead, keybindings):
            stdscr.clear()
            break


def pretty_print_item(stdscr, description):
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS - 10
    SNIP = LINES - 13

    tp = []
    for n in description.split("\n"):
        tp.append(n.strip())

    description = "\n".join(tp)
    paragraphs = description.split("\n\n")

    np = []
    for p in paragraphs:
        np.append(textwrap.fill(p, columns))

    outtext = "\n".join(np)
    outlines = outtext.split('\n')


    if len(outlines) > SNIP:
        outlines[SNIP - 1] = outlines[SNIP -1][:-3] + '...'
    
    for line in outlines[:SNIP]:
        if line == '* * *':
            line = "-"*columns

        stdscr.addstr("   " + line + '\n')


def pretty_item_lines(item, encoding='latin-1'):
    LINES, COLS = stdscr.getmaxyx()
    columns = item.pager.cols
    SNIP = item.pager.rows

    if item.html:
        html = item.html#.encode(encoding, 'replace')
        html2text.BODY_WIDTH = item.pager.cols - 4
        lines = html2text.html2text(html).splitlines()
        outlines = []
        for line in lines:
            if line == '* * *':
                line = "-"*columns
            outlines.append("   " + line)        
        return "\n".join(outlines).encode(encoding, 'replace')
        
    description = item.description.encode(encoding, 'replace')

    tp = []
    for n in description.split("\n"):
        tp.append(n.strip())
    

    description = "\n".join(tp)
    paragraphs = description.split("\n\n")

    np = []
    for p in paragraphs:
        np.append(textwrap.fill(p, columns - 4))

    outtext = "\n\n".join(np)
    outlines_raw = outtext.split('\n')
    outlines = []
    
    for line in outlines_raw:
        if line == '* * *':
            line = "-"*columns
        outlines.append("   " + line)

    return "\n".join(outlines)

  
def draw_item(stdscr, feed, use_colors=1, encoding='latin-1'):
    ypos = 4
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS - 10
    maxlines = LINES - 13
    
    item = feed.highlighted
    
    if not item.pager:
        item.pager = Pager(maxlines, columns)
        item.pager.data(pretty_item_lines(item))

    if columns != item.pager.cols or maxlines != item.pager.rows:
        item.pager.resize(maxlines, columns)

    stdscr.move(0,0)
    stdscr.clear()

    draw_header(stdscr, "")

    des = feed.description.encode(encoding, 'replace')
    if len(des) > columns:
        des = des[:columns - 5 - 3] + '...'

    stdscr.addstr(2, 1, des, curses.A_BOLD)

    stdscr.move(5,0)

    stdscr.attron(curses.A_BOLD)
    pretty_print_item(stdscr, item.title.encode(encoding, 'replace'))
    stdscr.attroff(curses.A_BOLD)

    # draw page status
    if item.pager.pages > 0:
        status = "page: %s/%s" % (item.pager.page + 1, item.pager.pages +1)
        stdscr.move(6, columns - len(status))
        stdscr.addstr(status)
    
    stdscr.move(8,0)
    stdscr.addstr(item.pager.data())

    draw_link(stdscr, item)
    
    # ok it's read now
    item.readstatus = 1


def draw_link(stdscr, item):
    ypos = 4
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS - 10
    maxlines = LINES - 6

    # Clear line
    stdscr.move(maxlines + 2, 1)
    stdscr.clrtoeol()
    
    stdscr.attron(curses.A_BOLD)
    
    syscall = doupdatelink(stdscr, item.link)

    #Show only link
    if len(item.link) > columns:
        stdscr.addstr(maxlines + 2, 1, "-> " + item.link[:columns-5] + " ...")
    else:
        stdscr.addstr(maxlines + 2, 1, "-> " + item.link)
    stdscr.attroff(curses.A_BOLD)


def draw_news(stdscr, feed, use_colors=USE_COLORS, encoding='latin-1'):
    global cur_feed
    
    ypos = 4
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS - 10
    maxlines = LINES - 6
    
    stdscr.move(0,0)

    draw_header(stdscr, "")

    if use_colors:
        curses.A_STANDOUT = curses.color_pair(18)

    cur_feed = feed

    if not feed.highlighted:
        feed.highlighted = feed.items[feed.sorted[feed.first_scr_ptr]]

    if feed.description:
        des = feed.description.encode(encoding, 'replace')

        if len(des) > columns:
            des = des[:columns-5-3] + '...'
        stdscr.addstr(2, 1, des, curses.A_BOLD)

    for item in feed.sorted[feed.first_scr_ptr:]:
        item = feed.items[item]
        stdscr.move(ypos, 0)
        stdscr.clrtoeol()

        if item.title:
            title = item.title.encode(encoding, 'replace')
        else:
            title = item.link

        if not item.readstatus:
            stdscr.attron(curses.A_BOLD)
            curses.A_STANDOUT = curses.A_STANDOUT|curses.A_BOLD

        if item == feed.highlighted:
            draw_link(stdscr, item)
            
            stdscr.attron(curses.A_STANDOUT)
            stdscr.addstr(ypos, 1, " "* (COLS - 2))
            
        if len(title) > columns:
            stdscr.addstr(ypos, 1, title[:columns] + '...')
        else:
            stdscr.addstr(ypos, 1, title)

        if not item.readstatus:
            stdscr.attroff(curses.A_BOLD)

            if use_colors:
                curses.A_STANDOUT = curses.color_pair(18)
            
        if item == feed.highlighted:
            stdscr.attroff(curses.A_STANDOUT)
        
        ypos += 1
        if ypos > maxlines:
            break

        
def draw_feeds(stdscr, feeds, highlighted='', keybindings={}):
    ypos = 2
    LINES, COLS = stdscr.getmaxyx()
    columns = COLS - 10
    maxlines = LINES - 6

    if USE_COLORS:
        curses.A_STANDOUT = curses.color_pair(18)

    if not feeds:
        outstr = "No items to show. Press 'a' to add feeds"

        center = columns // 2
        cos = len(outstr)// 2
        
        stdscr.addstr(10, center - cos, outstr)
        return
        
    for feed in feeds[first_scr_ptr:]:
        stdscr.move(ypos, 0)
        stdscr.clrtoeol()
        newcount = 0

        for i in feed.items:
            if not feed.items[i].readstatus:
                newcount += 1

        if feed == highlighted:
            draw_link(stdscr, feed)
            stdscr.attron(curses.A_STANDOUT)
            stdscr.addstr(ypos, 1, " " * (COLS-2))
            
        if feed.title:
            title = feed.title
        else:
            title = feed.link

        if feed.bozo and cfg.get_bozo():
            title = "*bozo* " + title
            
        if len(title) > columns:
            stdscr.addstr(ypos, 1, title[:columns] + '...')
        else:
            stdscr.addstr(ypos, 1, title)

        if feed.update_msg:
            outstr = feed.update_msg
        elif newcount:
            outstr = "(%i new)" % newcount
        else:
            outstr = ""

        stdscr.addstr(ypos, COLS - len(outstr) -1, outstr)            
            
        if feed == highlighted:
            stdscr.attroff(curses.A_STANDOUT)

        ypos += 1
        if ypos > maxlines:
            break
        

def doupdatelink(stdscr, link):
    # FIXME: some weird stuff here, clean up and rewrite
    global syscall
    try:
        syscall = cfg.get_browser() % link
    except TypeError:
        draw_status(stdscr, "Error in browser command!", 1)
        draw_status(stdscr, "'%s' missing %%s?" % cfg.get_browser(), 0)

    return syscall

            
def do_main_cmdloop(stdscr, typeahead, keybindings):
    global cur_cmd_grp

    quit = 0

    uiinput = stdscr.getch();

    if (typeahead):
        pass
    else:
        # isn't python just swell,
        # well, just look at this code :-)
        if uiinput < curses.KEY_MIN:
            try:
                uiinput = chr(uiinput)
            except ValueError:
                pass

        if keybindings.has_key(uiinput):
            method = keybindings[uiinput]
            g = globals()

            if g.has_key(method):
                quit = do_unlocked(g[method])(stdscr, bindings=keybindings)
                if quit:
                    return 1
        else:
            pass


    # ctrl+o shows next cmd group
    if (uiinput == chr(15) ):
        do_unlocked(keybind_morecmds)(stdscr, bindings=keybindings)

    return 0



class FeedParser:
    def __init__(self, cur_ptr):
        
        new_items = {}
        downloaded_items ={}
        orginal_sort = []
        self.error = ""

        # not really needed since feedparser isn't
        # doing the actual download for the moment
        feedparser.USER_AGENT = USER_AGENT

        rssDocument = feedparser.parse(cur_ptr.feed_data)

        try:
            # FIXME: when user has set title, don't check for updates,
            # otherwise check every time
            if not cur_ptr.title or cur_ptr.title == "(no title)":
                cur_ptr.title = strip_tags(rssDocument['feed']['title'])
                cur_ptr._title = cur_ptr.title 
        except:
            cur_ptr.title = "(no title)"

        try:
            cur_ptr.link = rssDocument['feed']['link']
        except:
            cur_ptr.link = ""

        try:
            cur_ptr.description = strip_tags(rssDocument['feed']['description'])
        except:
            cur_ptr.description = ""

        if not cur_ptr.description:
            cur_ptr.description = cur_ptr.title

        for item in rssDocument['entries']:

            new_item = NewsItem()
            new_item.title = html2text.html2text(item.get('title') or "(no title)")

            new_item.timestamp = int(time.time())

            link = item.get('link')
            if link[0] == '/':
                _feed_url = urlparse.urlparse(cur_ptr.link)
                link = urllib.quote(link)
                link = "://".join(_feed_url[:2]) + link

            new_item.link  = link

            # find a unique id of sorts..
            if item.has_key('guid'):
                id = item['guid']
            elif item.has_key('id'):
                id = item['id']
            else:
                id = link

            new_item.id = id

            # get the description
            if item.has_key('description'):
                description = item['description']
            else:
                description = "(no description)"

            if has_html(description):
                new_item.description = html2text.html2text(strip_links(description))
                new_item.html = strip_links(description)
            else:
                new_item.description = description
            
            if not cur_ptr.items.has_key(new_item.id):
                cur_ptr.items[new_item.id] = new_item
                orginal_sort.append(new_item.id)


        cur_ptr.sorted = orginal_sort + cur_ptr.sorted

            

def strip_tags(txt):
    """ Strip html tags """
    if txt:
        tags = re.compile('<.*?>', re.S)
        return tags.sub('', txt)
    return txt

def has_html(txt):
    if not txt: return 0
    tags = re.compile('<.*?>', re.S)
    qoutes = re.compile('&.*?;', re.S)
    if tags.search(txt) or qoutes.search(txt):
        return 1

    
def strip_links(txt):

    if not txt:
        return ''
    
    link = re.compile('</?a.*?>', re.S|re.I)
    img = re.compile('</?img.*?>', re.S|re.I)    
    br = re.compile('<br.*?>', re.S|re.I)
    
    txt = link.sub('', txt)
    txt = img.sub('', txt)
    txt = br.sub('<br>', txt)
    
    return txt

def clean_up_and_exit(func, error):
    global stdscr
    if not error:
        save_all(stdscr)

    stdscr.clear()
    stdscr.refresh()
    curses.endwin()

    if not error:
        print "Bye\n"

        sys.exit(0)

    else:
        print "Aborting program execution!"
        print "An internal error occured. Goodnews has quit, no changes has been saved!"
        print "----"
        print "While executing: %s" % func
        print "Error as reported by the system: %s\n" % error
        sys.exit(1)



# slashes in filenames is a problem
def hashurl(url):
    return url.replace('/', '_')

    
#/* Load config and populate caches. */
def load_state_config(stdscr):

    global COLOR, keybinding, cfg

    cfg = config.Config()
    configdir = cfg.get_configdir()
    cachedir = cfg.get_cachedir()
    timeoutsocket.setDefaultSocketTimeout(cfg.get_timeout())


    if not os.path.exists(configdir):
        try:
            os.mkdir (configdir, 0755)
        except OSError, err:
            clean_up_and_exit ("Creating config directory", err);

    else:
        if not os.path.isdir(configdir):
            clean_up_and_exit ("Creating config directory",
                          "A file with the same name exists!")
        
    if not os.path.exists(cachedir):
        try:
            os.mkdir(cachedir, 0755)
        except OSError, err:
            clean_up_and_exit ("Creating config directory cache/", err)
    else:
        if not os.path.isdir(cachedir):
            clean_up_and_exit ("Creating config directory cache",
                          "A file with the same name exists!")

    draw_status (stdscr, "Reading configuration settings...", 0)

    # list of feeds
    #fname = configdir + "/urls"

    for url in cfg.get_feeds():
        new_ptr = load_feed(stdscr, url)
        if new_ptr:
            first_ptr.append(new_ptr)
        
    # defaults keybindings 
    keybinding['n'] = 'keybind_next'
    keybinding['p'] = 'keybind_prev'
    keybinding['q'] = 'keybind_quit'
    keybinding['a'] = 'keybind_addfeed'
    keybinding['D'] = 'keybind_delfeed'
    keybinding['m'] = 'keybind_allread'
    keybinding['B'] = 'keybind_browser'
    keybinding['T'] = 'keybind_feedname'
    keybinding['E'] = 'keybind_editfeedurl'
    keybinding['P'] = 'keybind_moveup'
    keybinding['N'] = 'keybind_movedown'
    #keybinding['i'] = 'keybind_feedinfo'
    keybinding['r'] = 'keybind_reload'
    keybinding['R'] = 'keybind_reloadall'
    keybinding['o'] = 'keybind_urljump'
    #keybinding['O'] = 'keybind_urljump2'
    #keybinding['s'] = 'keybind_sortfeeds'
    #keybinding['b'] = 'keybind_pup'
    #keybinding[' '] = 'keybind_pdown'
    keybinding[' '] = 'keybind_select'
    keybinding['S'] = 'keybind_saveall'   
    #keybinding['C'] = 'keybind_cursor'
    #keybinding['f'] = 'keybind_filter'
    #keybinding['g'] = 'keybind_filtercurrent'
    #keybinding['F'] = 'keybind_nofilter'
    #keybinding['h'] = 'keybind_help'
    #keybinding['A'] = 'keybind_about'

    keybinding['*'] = 'keybind_bozo'
    
    # other keybindings
    #keybinding[curses.KEY_LEFT] = 'keybind_prev'
    #keybinding[curses.KEY_RIGHT] = 'keybind_next'
    keybinding[curses.KEY_UP] = 'keybind_prev'
    keybinding[curses.KEY_DOWN] = 'keybind_next'
    #keybinding[curses.KEY_NPAGE] = 'keybind_pdown'
    #keybinding[curses.KEY_PPAGE] = 'keybind_pup'
    keybinding[curses.KEY_RESIZE] = 'keybind_resize'
    
    #keybinding['\t'] = 'keybind_tab'
    keybinding['\n'] = 'keybind_select'
    # ctrl-g
    #keybinding['\x07'] = 'keybind_ctrlg'
    # ctrl-u
    #keybinding['\x15'] = 'keybind_ctrlu'
    #keybinding['^O'] = 'keybind_morecmds'
    keybinding['V'] = 'debug_shell'
    

    # FIXME: read keybindings from file here
	
    use_colors = USE_COLORS

    # FIXME: read color config from file here
    


class UpdateFeedThread(threading.Thread):

    def __init__(self,tlock, stdscr, cur_ptr, first_ptr, draw_feeds, highlighted, keybindings):

        threading.Thread.__init__(self)

        self.stdscr = stdscr
        self.cur_ptr = cur_ptr
        self.first_ptr = first_ptr
        self.draw_feeds = draw_feeds
        self.tlock = tlock
        self.highlighted = ''

    def draw_status_tlock(self, stdscr, txt, delay=0):
        self.tlock.acquire()            
        draw_status(stdscr, txt, delay)
        self.tlock.release()            

    def run(self):
        try:
            self.real_run()
            draw_feeds(self.stdscr, self.first_ptr, self.highlighted)
            draw_footer(self.stdscr, cur_cmd_grp, keybindings)
            stdscr.refresh()
        except:
            pass

    def real_run(self):
        if not self.cur_ptr:
            return 0
        LINES, COLS = stdscr.getmaxyx()
        #self.cur_ptr.update_msg = "(Downloading)"
        self.draw_status_tlock(stdscr, "Downloading " + self.cur_ptr.feedurl[:COLS], 0)
        try:
            feed = urllib.urlopen(self.cur_ptr.feedurl)
            feed_data = feed.read()
            #feed = StringIO.StringIO(feed_data)

        except IOError, err:
            self.draw_status_tlock(stdscr, "Downloading: "+err[1][1], 1)
            return 2
        except timeoutsocket.Timeout, err:
            self.draw_status_tlock(stdscr,str(err), 1)
            return 1

        self.cur_ptr.feed_data = feed_data
        #self.cur_ptr.feed = feed

        if not self.cur_ptr.title:
            self.cur_ptr.title = self.cur_ptr.feedurl
        if not self.cur_ptr.link:
            self.cur_ptr.link = self.cur_ptr.feedurl

        #self.cur_ptr.update_msg = "(Parsing)"
        self.draw_status_tlock(stdscr, "Parsing: " + self.cur_ptr.feedurl[:COLS], 0)
        xml = FeedParser(self.cur_ptr)

        #self.cur_ptr.update_msg = "(Expire)"
        self.draw_status_tlock(stdscr, "Expire items: " + self.cur_ptr.feedurl[:COLS], 0)

        expire_items(stdscr, self.cur_ptr)

        #Don't mess up highlight
        self.cur_ptr.highlighted = None

        self.cur_ptr.update_msg = ""
        self.draw_status_tlock(stdscr, "", 0)

        return 1

        
# Update feed from server.
def update_feed(stdscr, cur_ptr):

    if not cur_ptr:
        return 0

    LINES, COLS = stdscr.getmaxyx()

    draw_status(stdscr, "Downloading " + cur_ptr.feedurl[:COLS], 0)

    try:
        feed = urllib.urlopen(cur_ptr.feedurl)
        feed_data = feed.read()
        #cur_ptr.feed = StringIO.StringIO(cur_ptr.feed_data)
        
    except IOError, err:
        draw_status(stdscr, "Download failed: "+err[1][1], 1)
        return 2
    except timeoutsocket.Timeout, err:
        draw_status(stdscr,str(err), 1)
        return 1
    
    cur_ptr.feed_data = feed_data
    
    #if not cur_ptr.feed:
    #    return 0

    draw_status(stdscr, "Parsing " + cur_ptr.feedurl[:COLS], 0)
    xml = FeedParser(cur_ptr)

    if cur_ptr.bozo:
        draw_status(stdscr, "Warning: bozo XML! Maybe not a RSS feed?", 2)

    #Don't mess up highlight
    #cur_ptr.highlighted = None
    
    expire_items(stdscr, cur_ptr)

    #draw_status(stdscr, "", 0)
    return 1


def update_all_feeds(stdscr, first_ptr, draw_feeds=None, highlighted='', keybindings={}):
    global update_all_running 
    
    if updatelock.acquire(False) == False:
        return
    
    update_all_running = 1
    
    tlock = threading.Lock()

    threads = []

    # before we begin, redraw the feeds without a highlight bar
    draw_feeds(stdscr, first_ptr, highlighted='')

    draw_status(stdscr, "Updating all feeds", 0)
    for cur_ptr in tuple(first_ptr):

        threads.append(UpdateFeedThread(tlock, stdscr, cur_ptr, first_ptr, draw_feeds, highlighted, keybindings))
        
        threads[-1].setDaemon(0)
        threads[-1].start()

    # wait for the threads
    for t in threads:
        t.join()


    #draw_status(stdscr, "", 0)
    update_all_running = 0
    updatelock.release()

    draw_status(stdscr, "Update complete.", 0)
    draw_footer(stdscr, cur_cmd_grp, keybindings)
    stdscr.refresh()

def expire_items(stdscr, cur_ptr):

    if not cfg.get_expire(): 
        return
    
    amount = cfg.get_expireamount()
    timeout = cfg.get_expiretime() * 60 
    now = int(time.time())

    # remove items we have already expired
    for item in cur_ptr.sorted[:]:
        hash = md5.md5(cur_ptr.items[item].link).hexdigest()
        if hash in cur_ptr.expired:
            #cur_ptr.expired[hash] = cur_ptr.items[item].readstatus 
            cur_ptr.sorted.remove(item)
            del(cur_ptr.items[item])
            
    # amount overrides
    if 0: #amount:
        for item in cur_ptr.sorted[amount:]: 
            cur_ptr.expired[hash] = cur_ptr.items[item].readstatus 
            del(cur_ptr.items[item])
        cur_ptr.sorted = cur_ptr.sorted[:amount]
    else:
        for item in cur_ptr.sorted:
            if (cur_ptr.items[item].timestamp + timeout) < now:
                i = cur_ptr.items[item]
                hash = md5.md5(i.link).hexdigest()
                cur_ptr.expired[hash] = i.readstatus 

                del(cur_ptr.items[item])
                cur_ptr.sorted.remove(item)

    #draw_status(stdscr, "", 0)
    cur_ptr.highlighted = None

#/* Load feed from disk. And call update_feed if neccessary. */
def load_feed(stdscr,url):

    fname = cfg.get_configdir() + "/cache/%s.pickle" % (hashurl(url))

    try:
        cache = open(fname)
        feed = cPickle.load(cache)

        feed.update_msg = ""

        return feed
    except:
        tmp = "Cache for %s is toast. Reloading from server..." % url
        draw_status (stdscr, tmp, 0);
        feed = Feed()
        feed.feedurl = url        
        if update_feed(stdscr, feed):
            return feed

class UpdateThread(threading.Thread):
    def __init__(self, stdscr, interval=300):
        threading.Thread.__init__(self)
        self.stdscr = stdscr
        self.sleeptime = interval
  
    def run(self):
        while 1:
            if mainmenu:
                keylocked(update_all_feeds)(stdscr, first_ptr, draw_feeds, '', {})
            time.sleep(self.sleeptime)


def load_all_feeds(stdscr):
    # work on a copy of first_ptr
    for cur_ptr in tuple(first_ptr):
        tmp = "Loading cache for %s..." % cur_ptr.feedurl
        draw_status(stdscr, tmp, 0)
        load_feed(stdscr, cur_ptr)


# write config and cache to disk
def save_all(stdscr):
    global cfg
    
    #FIXME: write cache to file more often, not only on exit
    #FIXME: only write when things have changed
    draw_status(stdscr, "Saving settings...", 0)

    cfg.add_feeds([ptr.feedurl for ptr in first_ptr])
    cfg.write()

    for cur_ptr in first_ptr:
        save_feed_cache(stdscr, cur_ptr)


def save_feed_cache(stdscr, feed):
    hashme = hashurl(feed.feedurl);
    fname = cfg.get_configdir() + "/cache/%s.pickle" % (hashme)        
    cache = open(fname, "wb")
    
    # dont save the pager
    for item in feed.items: 
        feed.items[item].pager = None

    cPickle.dump(feed, cache)
    cache.close()


def add_feed(stdscr, first_ptr, default=""):
    LINES, COLS = stdscr.getmaxyx()

    draw_status(stdscr, "Enter URL of the feed you want to add. Blank line to abort.", 0);

    url = ex_entry_field(stdscr)

    draw_status(stdscr, "")
    
    if not url:
        return 0
	
    #FIXME: do more url checking here
    if not url.startswith("http://"):
        return 0

    new_ptr = Feed()
    new_ptr.feedurl = url
    first_ptr.append(new_ptr)
    
    # download it
    update_feed (stdscr, new_ptr)

    return 1


def run(argv):
    global stdscr
    global updatelock
    global mainmenu
    global keylock
    global has_keylock
    #FIXME: argv checking

    has_keylock = False
    mainmenu = True

    stdscr = InitCurses();
    updatelock = threading.Lock()
    keylock = threading.Lock()

    try:
        stdscr.refresh()
        # load configs and caches
        load_state_config(stdscr);

        # load autoupdater
        if cfg.get_autoupdate() != '0':
            interval = int(cfg.get_updateinterval());

            update_thread = UpdateThread(stdscr, interval)
            update_thread.start()

        #load_all_feeds(stdscr);        
        enter_main(stdscr, first_ptr, keybinding)

    except KeyboardInterrupt:
        pass
    except SystemExit:
        pass
    except:
        import traceback, StringIO, sys
        s = StringIO.StringIO()
        sys.last_type = sys.exc_type
        sys.last_value = sys.exc_value
        sys.last_traceback = sys.exc_traceback.tb_next
        traceback.print_exception(sys.last_type, sys.last_value, sys.last_traceback, file=s)
        
        dump_traceback(stdscr, s.getvalue())

    clean_up_and_exit("","")


def debug_shell(stdscr, **args):
    from code import InteractiveConsole
    curses.reset_shell_mode()
    import __main__
    locals = __main__.__dict__
    sh = InteractiveConsole(locals)
    sh.interact()
    stdscr.clear()
    curses.reset_prog_mode()


if __name__ == '__main__':
    if len(sys.argv) == 2 and sys.argv[1] == '--clear-cache':
        cfg = config.Config()
        cachedir = cfg.get_cachedir()
        print cachedir
        ret = os.system('rm -rf %s' % cachedir)
        sys.exit(ret)

    run(sys.argv)
