import curses, curses.wrapper, curses.ascii
#import curses.ascii

#import ctypescurses._ctypescurses as curses

class Textfield:

    def __init__(self, win, text="text", echo=""):#, h=1, w=20, x=2, y=1, title="", text="test"):

        """
        try:
        self.entry = curses.newwin(h, w-4+1, x, y)
        except curses.error:
            print 'Can\'t create window'
            sys.exit(-1)
        """
        self.entry = win
        h, w = self.entry.getmaxyx()
        
        self.entry.keypad(1)    

        self.echo = echo
        if self.echo:
            curses.echo(0)
            
        self.entry_w = w - 1
        self.text = text
        self.pos = len(self.text)


    def show(self):
        self.refresh()

    def refresh(self):

        text = self.text
        pos = self.pos
        ew = self.entry_w
        ltext = len(text)

        if pos < ew:
            relpos = pos
            if ltext < ew:
                textstr = text + ' ' * (ew - ltext)
            else:
               textstr = text[:ew]
        else:
            if pos > ltext - (ew-1):
                relpos = ew - 1 - (ltext - pos)
                textstr = text[ltext-ew+1:] + ' '
            else:
                relpos = pos - int(pos/ew)*ew
                textstr = text[int(pos/ew)*ew:int(pos/ew)*ew+ew]

        self.entry.erase()
        if self.echo:
            self.entry.addstr(self.echo * len(text[:ew]))
        else:
            self.entry.addstr(textstr[:ew])
        self.entry.move(0, relpos)


        
    def __call__(self):
        return self.run()
        
    def run(self):
        self.show()
        while 1:
            self.entry.refresh()
            ch = self.entry.getch()

            if ch == curses.ascii.SOH:  # ^a
                self.pos = 0
                self.refresh()

            elif ch == curses.ascii.ENQ: # ^e
                self.pos = len(self.text)
                self.refresh()

            elif ch == curses.ascii.BEL:   # ^g
                return "" # abort

            elif ch == curses.ascii.VT: # ^k
                self.text = self.text[:self.pos]
                self.refresh()
                

            elif ch == curses.KEY_LEFT:
                if self.pos > 0:
                    self.pos -= 1
                    self.refresh()
                    
            elif ch == curses.KEY_RIGHT:
                if self.pos < len(self.text):
                    self.pos += 1
                    self.refresh()
                
            elif ch in (curses.ascii.BS, curses.KEY_BACKSPACE): # delete

                self.text = self.text[:self.pos - 1] + \
                            self.text[self.pos + 1:]
                if self.pos > 0:
                    self.pos -= 1
                self.refresh()                

            elif ch == ord('\n'):
                return self.text
    
            else:
                if curses.ascii.isprint(ch):
                    self.text = self.text[:self.pos] + \
                                chr(ch) + self.text[self.pos:]
                    self.pos += 1
                    self.refresh()


        
def test(stdscr):
    global cap
    curses.use_default_colors()
    win = curses.newwin(3, 22, 1, 1)
    win.box()

    win.refresh()
    w = curses.newwin(1, 20, 2, 2)

    tf = Textfield(w, echo="*")
    cap = tf()


if __name__ == '__main__':
    #tdscr = curses.initscr()
    #stdscr.box()
    curses.wrapper(test)
    #test(stdscr)
    
    print cap
